//this file is part of eMule
//Copyright (C)2002-2008 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "MuleStatusBarCtrl.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
#include "ServerWnd.h"
#include "StatisticsDlg.h"
#include "ChatWnd.h"
#include "Sockets.h"
#include "Server.h"
#include "ServerList.h"
//==> NextEMF New Tooltips [Rayita]
#include "UploadQueue.h"
#include "DownloadQueue.h"
#include "math.h"
//<== NextEMF New Tooltips [Rayita]


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// CMuleStatusBarCtrl

IMPLEMENT_DYNAMIC(CMuleStatusBarCtrl, CStatusBarCtrl)

BEGIN_MESSAGE_MAP(CMuleStatusBarCtrl, CStatusBarCtrl)
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()

CMuleStatusBarCtrl::CMuleStatusBarCtrl()
{
}

CMuleStatusBarCtrl::~CMuleStatusBarCtrl()
{
}

void CMuleStatusBarCtrl::Init(void)
{
//	EnableToolTips();//==> NextEMF New Tooltips [Rayita]
}

void CMuleStatusBarCtrl::OnLButtonDblClk(UINT /*nFlags*/, CPoint point)
{
	int iPane = GetPaneAtPosition(point);
	switch (iPane)
	{
		case SBarLog:
			AfxMessageBox(_T("eMule ") + GetResString(IDS_SV_LOG) + _T("\n\n") + GetText(SBarLog));
			break;

		case SBarUsers:
			theApp.emuledlg->serverwnd->ShowNetworkInfo();
			break;
		
		case SBarUpDown:
			theApp.emuledlg->SetActiveDialog(theApp.emuledlg->statisticswnd);
			break;
		
		case SBarConnected:
			theApp.emuledlg->serverwnd->ShowNetworkInfo();
			break;

		case SBarChatMsg:
			theApp.emuledlg->SetActiveDialog(theApp.emuledlg->chatwnd);
			break;
	}
}

int CMuleStatusBarCtrl::GetPaneAtPosition(CPoint& point) const
{
	CRect rect;
	int nParts = GetParts(0, NULL);
	for (int i = 0; i < nParts; i++)
	{
		GetRect(i, rect);
		if (rect.PtInRect(point))
			return i;
	}
	return -1;
}

//==> NextEMF New Tooltips [Rayita]
HICON CMuleStatusBarCtrl::GetTipInfo(CString &info)
{
	CPoint pt;
	::GetCursorPos(&pt);
	ScreenToClient(&pt);
	info.Empty();
	switch (GetPaneAtPosition(pt))
	{
		case SB_LOG:
			info = GetText(SB_LOG);
			if(info.GetLength() > 100)
			{
				int m = (int)ceil((float)info.GetLength() / 100);
				for(int i = 0; i < m; i++)
				{
					int n = (info.GetLength() / m) * (i + 1);
					while (info[n] != _T(' ') && n < info.GetLength()) n++;
					if(n < info.GetLength())
						info.SetAt(n, _T('\n'));
					else
						break;
				}
			}
			break;
		case SB_UP_SPEED:
			theApp.uploadqueue->GetTransferTipInfo(info);
			break;
		case SB_DN_SPEED:
			theApp.downloadqueue->GetTransferTipInfo(info);
			break;
		case SB_SERVER:
		{
			CServer* server = theApp.serverconnect ? theApp.serverconnect->GetCurrentServer() : NULL;
			if(server && (server = theApp.serverlist->GetServerByAddress(server->GetAddress(), server->GetPort())) != NULL)
				return server->GetServerTooltipInfo(info);

			break;
		}
	}
	return (HICON)NULL;
}
//<== NextEMF New Tooltips [Rayita]
